package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.biz.IntegralRuleBiz;
import com.xxfc.platform.activity.entity.IntegralRule;
import com.xxfc.platform.activity.vo.IntegralRuleDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "integralRule")
@Api(value = "积分规则")
public class IntegralRuleController {

    @Autowired
    IntegralRuleBiz integralRuleBiz;

    @PostMapping(value = "/add")
    @ApiOperation(value = "添加积分规则")
    public ObjectRestResponse add(IntegralRule integralRule) {
        return integralRuleBiz.add(integralRule);
    }

    @PostMapping(value = "/delete")
    @ApiOperation(value = "删除积分规则")
    public ObjectRestResponse deleteOne(Integer id) {
        return integralRuleBiz.deleteOne(id);
    }

    @GetMapping(value = "/one")
    @ApiOperation(value = "根据id获取制定规则")
    public ObjectRestResponse<IntegralRule> getOne(IntegralRule integralRule) {
        return integralRuleBiz.getOne(integralRule);
    }

    @GetMapping(value = "/list")
    @ApiOperation(value = "获取所有的规则")
    public ObjectRestResponse<PageDataVO> getList(IntegralRuleDto integralRuleDto) {
        return integralRuleBiz.getAll(integralRuleDto);
    }

}
