package com.xxfc.platform.activity.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.entity.IntegralUserTotal;
import com.xxfc.platform.activity.mapper.IntegralUserTotalMapper;
import com.xxfc.platform.activity.user.UserInfoBiz;
import com.xxfc.platform.activity.vo.IntegralRuleDto;
import com.xxfc.platform.activity.vo.IntegralUserTotalDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class IntegralUserTotalBiz extends BaseBiz<IntegralUserTotalMapper, IntegralUserTotal> {

    @Autowired
    UserInfoBiz userInfoBiz;

    /**
     * 添加用户总积分
     * @param integralUserTotalDto
     * @return
     */
    public ObjectRestResponse  add(IntegralUserTotalDto integralUserTotalDto) {
        AppUserDTO appUserDTO = userInfoBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        if(integralUserTotalDto == null || integralUserTotalDto.getPoint() == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        integralUserTotalDto.setUserId(appUserDTO.getUserid());
            List<IntegralUserTotal> integralUserTotalList = mapper.selectAllByParam(integralUserTotalDto);
            if(integralUserTotalList != null && integralUserTotalList.size() > 0) {
                integralUserTotalList.get(0).setTotalPoint(integralUserTotalList.get(0).getTotalPoint() + integralUserTotalDto.getPoint());
                integralUserTotalList.get(0).setRestPoint(integralUserTotalList.get(0).getRestPoint() + integralUserTotalDto.getPoint());
                updateByIdRe( integralUserTotalList.get(0));
                return ObjectRestResponse.succ();
            }
            IntegralUserTotal integralUserTotal = new IntegralUserTotal();
            integralUserTotal.setUserId(appUserDTO.getUserid());
            integralUserTotal.setTotalPoint(integralUserTotalDto.getPoint());
            integralUserTotal.setRestPoint(integralUserTotalDto.getPoint());
            integralUserTotal.setIsdel(false);
            insertSelective(integralUserTotal);
            return ObjectRestResponse.succ();
    }

    /**
     * 删除信息
     * @return
     */
    public ObjectRestResponse deleteOne() {
        AppUserDTO appUserDTO = userInfoBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        IntegralUserTotalDto integralUserTotalDto = new IntegralUserTotalDto();
        integralUserTotalDto.setUserId(appUserDTO.getUserid());
        List<IntegralUserTotal> oldValue = mapper.selectAllByParam(integralUserTotalDto);
        if(oldValue == null || oldValue.size() <= 0) {
            return ObjectRestResponse.createDefaultFail();
        }
        oldValue.get(0).setIsdel(true);
        updateByIdRe(oldValue.get(0));
        return ObjectRestResponse.succ();
    }

    /**
     * 获取某个用户的积分信息
     * @return
     */
    public ObjectRestResponse<IntegralUserTotal> getByUser() {
        AppUserDTO appUserDTO = userInfoBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        IntegralUserTotalDto integralUserTotalDto = new IntegralUserTotalDto();
        integralUserTotalDto.setUserId(appUserDTO.getUserid());
        List<IntegralUserTotal> oldValue = mapper.selectAllByParam(integralUserTotalDto);

        return ObjectRestResponse.succ(oldValue == null || oldValue.size() <=0 ? null : oldValue.get(0));
    }

    /**
     * 获取所有的信息
     * @return
     */
    public ObjectRestResponse<PageDataVO> getAll(IntegralUserTotalDto integralUserTotalDto) {
        Query query = new Query(integralUserTotalDto);
        PageDataVO pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectAllByParam(integralUserTotalDto));
        return ObjectRestResponse.succ(pageDataVO);
    }


}
