package com.xxfc.platform.activity.biz;

import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.constant.RestCode;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.xxfc.platform.activity.entity.IntegralUserRecord;
import com.xxfc.platform.activity.entity.IntegralUserTotal;
import com.xxfc.platform.activity.mapper.IntegralUserRecordMapper;
import com.xxfc.platform.activity.user.UserInfoBiz;
import com.xxfc.platform.activity.vo.IntegralUserRecordDto;
import com.xxfc.platform.activity.vo.IntegralUserTotalDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
@Slf4j
public class IntegralUserRecordBiz extends BaseBiz<IntegralUserRecordMapper, IntegralUserRecord> {

        @Autowired
        UserInfoBiz userInfoBiz;

        @Autowired
        IntegralUserTotalBiz integralUserTotalBiz;
    /**
     * 添加用户积分记录
     * @param integralUserRecord
     * @return
     */
        public ObjectRestResponse add(IntegralUserRecord integralUserRecord) {
            if(integralUserRecord == null) {
                return ObjectRestResponse.paramIsEmpty();
            }
            if(integralUserRecord.getType() == 0) {//获取积分 增加总积分表
                ObjectRestResponse<IntegralUserTotal> objectRestResponse = integralUserTotalBiz.getByUser();
                if(objectRestResponse.getStatus() == RestCode.SUCCESS.getStatus() && objectRestResponse.getData() != null) {
                    IntegralUserTotal integralUserTotal = objectRestResponse.getData();
                    IntegralUserTotalDto integralUserTotalDto = new IntegralUserTotalDto();
                    integralUserTotalDto.setUserId(integralUserTotal.getUserId());
                    integralUserTotalDto.setPoint(integralUserRecord.getPoint());
                    integralUserTotalBiz.add(integralUserTotalDto);
                } else {
                    IntegralUserTotalDto integralUserTotalDto = new IntegralUserTotalDto();
                    integralUserTotalDto.setUserId(integralUserRecord.getUserId());
                    integralUserTotalDto.setPoint(integralUserRecord.getPoint());
                    integralUserTotalBiz.add(integralUserTotalDto);
                }

            } else if(integralUserRecord.getType() == 1) {//扣减积分
                ObjectRestResponse<IntegralUserTotal> objectRestResponse = integralUserTotalBiz.getByUser();
                if(objectRestResponse.getStatus() == RestCode.SUCCESS.getStatus() && objectRestResponse.getData() != null) {
                    IntegralUserTotal integralUserTotal = objectRestResponse.getData();
                    IntegralUserTotalDto integralUserTotalDto = new IntegralUserTotalDto();
                    integralUserTotalDto.setUserId(integralUserTotal.getUserId());
                    integralUserTotalDto.setPoint(- integralUserRecord.getPoint());
                    integralUserTotalBiz.add(integralUserTotalDto);
                } else {
                    return ObjectRestResponse.createFailedResult(1008,"用户积分不足");
                }
            }
            insertSelective(integralUserRecord);
            return ObjectRestResponse.succ();
            }

        /**
         * 删除一个用户记录
         * @param id
         * @return
         */
        public ObjectRestResponse deleteOne(Integer id) {
             if(id == null || id <=0 ) {
                    return ObjectRestResponse.paramIsEmpty();
             }
             IntegralUserRecord integralUserRecord = mapper.selectByPrimaryKey(id);
             if(integralUserRecord == null) {
                 log.info("删除的用户记录不存在，要删除的id ={}", id);
                 return ObjectRestResponse.createDefaultFail();
             }
             integralUserRecord.setIsdel(true);
             updateByIdRe(integralUserRecord);
             return ObjectRestResponse.succ();
        }

        /**
         *  根据获取某个用户的列表
         * @return
         */
        public ObjectRestResponse<PageDataVO> getUserList(IntegralUserRecordDto integralUserRecordDto) {
            AppUserDTO appUserDTO = userInfoBiz.getUserInfo();
            if (appUserDTO == null) {
                return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
            }
            Query query = new Query(integralUserRecordDto);
            PageDataVO pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectByUserId(appUserDTO.getUserid()));
            return ObjectRestResponse.succ(pageDataVO);
        }

        public ObjectRestResponse<List<IntegralUserRecord>> getByUserAndTime(IntegralUserRecordDto integralUserRecordDto) {
            if(integralUserRecordDto == null) {
                return ObjectRestResponse.paramIsEmpty();
            }
            List<IntegralUserRecord> integralUserRecordList = mapper.selectByUserAndTime(integralUserRecordDto);
            return ObjectRestResponse.succ(integralUserRecordList);
        }
}
