package com.xxfc.platform.activity.vo;

import com.github.wxiaoqi.security.common.vo.PageParam;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class IntegralRuleDto extends PageParam {
    /**
     * 主键id
     */
    private Integer id;

    /**
     * 周期单位:0-天,1-周；3-月；4-季；5-年
     */
    private Integer period;

    /**
     * 次数
     */
    private Integer number;

    /**
     * 积分
     */
    private Integer point;

    /**
     * 积分兑换:金额/分
     */
    private BigDecimal price;

    /**
     * 是否连续:0-不连续;1-连续
     */
    private Boolean isContinuity;

    /**
     * 多少天后连续算
     */
    private Integer finishDay;

    /**
     * n天获取的积分
     */
    private Integer finishPoint;

    /**
     * 是否启用:1-启用；0-停用
     */
    private Boolean status;

    /**
     * 创建时间
     */
    private Long crtTime;

    /**
     * 是否删除:0-正常；1-删除
     */
    private Boolean isdel;

    /**
     * 规则开始时间
     */
    private Long startTime;

    /**
     * 规则结束时间
     */
    private Long endTime;

    /**
     * 更新时间
     */
    private Long updTime;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 描述
     */
    private String desc;

    /**
     * 规则图片
     */
    private String img;

    /**
     * 排序
     */
    private Integer orderId;

    /**
     * 规则名称
     */
    private String name;

    /**
     * 获取积分规则
     */
    private String regulation;

    /**
     * json字符串 如：[{"day":4,"integeral":8},{"day":4,"integeral":8}]
     */
    private String otherRule;
}
