package com.xxfc.platform.activity.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name = "integral_user_record")
@Data
public class IntegralUserRecord {
    /**
     * 主键id
     */
    @Id
    private Integer id;

    /**
     * 用户id
     */
    @Column(name = "user_id")
    private Integer userId;

    /**
     * 0-获取积分；1-抵扣积分
     */
    private Integer type;

    /**
     * 积分数
     */
    private Integer point;

    /**
     * 积分规则id
     */
    @Column(name = "integral_rule_id")
    private Integer integralRuleId;

    /**
     * 积分时间
     */
    @Column(name = "crt_time")
    private Long crtTime;

    /**
     * 是否有效:1-有效；0-失效
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 是否删除：0-正常；1-删除
     */
    private Boolean isdel;

    /**
     * 获取积分的途径id:如订单id,评论id，签到记录id
     */
    @Column(name = "channel_id")
    private Integer channelId;


}