package com.xinxincaravan.caravan.vehicle.constant;

import com.google.common.collect.Maps;

import java.util.Map;

public enum RegionType {
    ALL(-1,"全国"),//这一类型不存在db中，只是用于查询所有国家
    COUNTRY(0,"国家"),
    PROVINCE(1,"省/直辖市"),
    CITY(2,"市"),
    TOWN(3,"镇/县"),
    ;

    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = Maps.newHashMap();

    static{
        for(RegionType constantType : RegionType.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    RegionType(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
