package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.AdminBootstrap;
import com.github.wxiaoqi.security.admin.biz.BaseUserMemberBiz;
import com.github.wxiaoqi.security.admin.biz.BaseUserMemberExportBiz;
import com.github.wxiaoqi.security.admin.dto.UserMemberDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.excel.ExcelImport;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 11:51
 */
@RestController
@RequestMapping("member")
public class UserMemberController {

    @Autowired
    private BaseUserMemberBiz memberBiz;

    @Autowired
    private BaseUserMemberExportBiz baseUserMemberExportBiz;

    /**
     * 购买会员
     *
     * @param userMemberDTO
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/user/buyMember", method = RequestMethod.POST)
    public ObjectRestResponse buyMember(@RequestBody UserMemberDTO userMemberDTO) throws Exception {
        memberBiz.updUserMemberByUserId(userMemberDTO);
        return ObjectRestResponse.succ();
    }

    /**
     * 订单更改会员
     *
     * @param userId
     * @param days
     * @param type   1-用户锁定下单；2-购买下单;3-取消订单
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/user/memberDays", method = RequestMethod.POST)
    public int memberDays(
            @RequestParam(value = "userId", defaultValue = "0") Integer userId,
            @RequestParam(value = "days", defaultValue = "0") Integer days,
            @RequestParam(value = "type", defaultValue = "1") Integer type
    ) throws Exception {
        return memberBiz.upMemberDays(userId, days, type);
    }




}
