package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.UserMemberLevelBiz;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import io.swagger.models.auth.In;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 11:51
 */
@RestController
@RequestMapping("member")
@IgnoreClientToken
public class MemberLevelController extends BaseController<UserMemberLevelBiz, BaseUserMemberLevel> {

    @Autowired
    private UserMemberLevelBiz memberBiz;

    @RequestMapping(value = "/app/unauth/levels", method = RequestMethod.GET)
    public @ResponseBody
    List<BaseUserMemberLevel> levels() throws Exception {
        return memberBiz.getLevesls();
    }

    @RequestMapping(value = "/app/unauth/level/list", method = RequestMethod.GET)
    public ObjectRestResponse<List<BaseUserMemberLevel>>list() throws Exception {
        return ObjectRestResponse.succ(memberBiz.getLevesls());
    }

    @RequestMapping(value = "/app/unauth/level/{type}", method = RequestMethod.GET)
    public @ResponseBody
    BaseUserMemberLevel level(@PathVariable Integer type) throws Exception {
         List<BaseUserMemberLevel> list=memberBiz.getLevesls();
         if(type!=null){
             if(list.size()>0){
                 for (BaseUserMemberLevel userMemberLevel:list){
                     if(userMemberLevel.getLevel()!=null&&userMemberLevel.getLevel()==type){
                         return userMemberLevel;
                     }
                 }
             }
         }
        return null;
    }
}
