package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.bo.UserTeamMemberBo;
import com.github.wxiaoqi.security.admin.entity.AppUserDetail;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.entity.AppUserRelation;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/11 14:44
 */
@Transactional
@Service
public class UserBusinessBiz {

    @Autowired
    private AppUserRelationBiz appUserRelationBiz;

    @Autowired
    private AppUserSellingWaterBiz appUserSellingWaterBiz;

    @Autowired
    private AppUserLoginBiz appUserLoginBiz;

    @Autowired
    private AppUserDetailBiz appUserDetailBiz;

    public PageDataVO<UserTeamMemberBo> findTeamMemberPageByUserId(Integer userId, Integer pageNo, Integer pageSize) {

        PageDataVO<UserTeamMemberBo> teamMemberPage = new PageDataVO<>();
        //根据用户id去关系表里查询下级
        PageDataVO<AppUserRelation> memberPage = appUserRelationBiz.findMemberPageByLeaderId(userId, pageNo, pageSize);

        List<AppUserRelation> teamMemberBos = memberPage.getData();
        if (CollectionUtils.isEmpty(teamMemberBos)) {
            return teamMemberPage;
        }

        List<Integer> memberIds = teamMemberBos.stream().map(team -> team.getUserId()).collect(Collectors.toList());
        Map<Integer, BigDecimal> memberIdAndIncomeMap = appUserSellingWaterBiz.findMemberIdAndIncomeMapByMemberIds(memberIds);
        if (memberIdAndIncomeMap == null) {
            return teamMemberPage;
        }

        Map<Integer,AppUserLogin> userIdAndAppUserLoginMap = appUserLoginBiz.findUserIdAndUserLoginMapByMemberIds(memberIds);
        Map<Integer, AppUserDetail> UserIdAndAppUserDetailMap  = appUserDetailBiz.findUserIdAndUserDetailMapByMemberIds(memberIds);

        List<UserTeamMemberBo> userTeamMemberBos = new ArrayList<>();
        UserTeamMemberBo userTeamMemberBo;
        for (AppUserRelation appUserRelation : teamMemberBos) {

            userTeamMemberBo = new UserTeamMemberBo();
            userTeamMemberBo.setLeagueTime(appUserRelation.getBindTime());
            userTeamMemberBo.setUserId(appUserRelation.getUserId());

            if (userIdAndAppUserLoginMap!=null){
                AppUserLogin appUserLogin = userIdAndAppUserLoginMap.get(appUserRelation.getUserId());
                userTeamMemberBo.setUserNamem(appUserLogin.getUsername());
            }
            if (UserIdAndAppUserDetailMap!=null){
                AppUserDetail appUserDetail = UserIdAndAppUserDetailMap.get(appUserRelation.getUserId());
                userTeamMemberBo.setHeadUrl(appUserDetail==null?"":appUserDetail.getHeadimgurl());
                userTeamMemberBo.setNickName(appUserDetail==null?"":appUserDetail.getNickname());
            }
            userTeamMemberBo.setIncome(memberIdAndIncomeMap.get(appUserRelation.getUserId()));
            userTeamMemberBos.add(userTeamMemberBo);
        }
        teamMemberPage.setPageNum(memberPage.getPageNum());
        teamMemberPage.setPageSize(memberPage.getPageSize());
        teamMemberPage.setTotalCount(memberPage.getTotalCount());
        teamMemberPage.setTotalPage(memberPage.getTotalPage());
        teamMemberPage.setData(userTeamMemberBos);
        return teamMemberPage;
    }
}
