package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.bo.UserIncomeBo;
import com.github.wxiaoqi.security.admin.dto.OrderGoodsDTO;
import com.github.wxiaoqi.security.admin.dto.OrderWaterDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserRelation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.github.wxiaoqi.security.admin.entity.AppUserSellingWater;
import com.github.wxiaoqi.security.admin.mapper.AppUserSellingWaterMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 拥金明细表
 *
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
@Service
@Slf4j
public class AppUserSellingWaterBiz extends BaseBiz<AppUserSellingWaterMapper,AppUserSellingWater> {


    @Autowired
    AppUserRelationBiz relationBiz;

     //计算用户拥金
     public  void doWaterByUserId(OrderWaterDTO orderWaterDTO){

         if(orderWaterDTO==null){
             log.info("计算用户拥金----doWaterByUserId----次数不能为空----");
             return;
         }
         //订单id
         Integer orderId=orderWaterDTO.getOrderId();
         //订单号
         String orderNo=orderWaterDTO.getOrderNo();
         //用户id
         Integer userId=orderWaterDTO.getUserId();
         //订单状态
          Integer status=orderWaterDTO.getStatus();
         List<OrderGoodsDTO> goodsDTOList=orderWaterDTO.getGoodsDTOList();
       log.info("计算用户拥金----doWaterByUserId----userId===="+userId+"---orderId==="+orderId+"---orderNo==="+orderNo+"--status=="+status);
       if(orderId==null||orderId==0||userId==null||userId==0||status==null||status==0){
           log.info("计算用户拥金----doWaterByUserId----次数不能为空----orderId==="+orderId);
            return;
       }
         AppUserRelation relation=relationBiz.getRelationByUserId(userId);
       if(relation==null||relation.getParentId()==null||relation.getParentId()==0){
           log.info("计算用户拥金----doWaterByUserId--------userId==="+userId+"---无上线");
            return;
       }
       Integer parentId=relation.getParentId();

       /* //商品id
         Integer goodId=orderWaterDTO.getGoodId();
         //商品价格
         Long price=orderWaterDTO.getPrice();*/

     }



    public Map<Integer, BigDecimal> findMemberIdAndIncomeMapByMemberIds(List<Integer> memberIds) {
         Map<Integer,BigDecimal> memberIdAndIncomeMap = new HashMap<>();
         List<UserIncomeBo> userIncomeBos = mapper.accquireIncomeByMemberIds(memberIds);
         if (CollectionUtils.isNotEmpty(userIncomeBos)){
             memberIdAndIncomeMap = userIncomeBos.stream().collect(Collectors.toMap(UserIncomeBo::getUserId,UserIncomeBo::getIncome));
         }
        return memberIdAndIncomeMap;
    }
}