package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 收入/支持明细表，每笔的进账，出账的详细记录
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
@Data
@Table(name = "my_wallet_detail")
public class MyWalletDetail implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键ID
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键ID")
    private Long id;
	
	    /**
     *  用户ID
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户ID")
    private String userId;
	
	    /**
     *  来源：0-活动，1-佣金，2-会员充值，10-提现，11-转账，12-购买
     */
    @Column(name = "source")
	@ApiModelProperty(value = "来源：0-活动，1-佣金，2-会员充值，10-提现，11-转账，12-购买")
    private Integer source;
	
	    /**
     *  收入/支出：0-收入，1-支出
     */
    @Column(name = "itype")
	@ApiModelProperty(value = "收入/支出：0-收入，1-支出")
    private Integer itype;
	
	    /**
     *  收入/支出的金额(分)
     */
    @Column(name = "amount")
	@ApiModelProperty(value = "收入/支出的金额(分)")
    private Long amount;
	
	    /**
     *  活动类型
     */
    @Column(name = "type")
	@ApiModelProperty(value = "活动类型")
    private Integer type;
	
	    /**
     *  活动id
     */
    @Column(name = "activity_id")
	@ApiModelProperty(value = "活动id")
    private Integer activityId;
	
	    /**
     *  单号
     */
    @Column(name = "cono")
	@ApiModelProperty(value = "单号")
    private String cono;
	
	    /**
     *  加上当时的收入的余额
     */
    @Column(name = "balance")
	@ApiModelProperty(value = "加上当时的收入的余额")
    private Long balance;
	
	    /**
     *  操作者ID(如果系统操作,-1)
     */
    @Column(name = "oper_user")
	@ApiModelProperty(value = "操作者ID(如果系统操作,-1)")
    private Integer operUser;
	
	    /**
     *  操作时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "操作时间", hidden = true )
    private Long crtTime;
	

}
