package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 钱包提现表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
@Data
@Table(name = "my_wallet_cath")
public class MyWalletCath implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键ID
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键ID")
    private Long id;
	
	    /**
     *  用户iD
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户iD")
    private String userId;
	
	    /**
     *  提现类别，第三方提现类别(0-微信，1-支付宝，2-银行卡)
     */
    @Column(name = "cath_type")
	@ApiModelProperty(value = "提现类别，第三方提现类别(0-微信，1-支付宝，2-银行卡)")
    private Integer cathType;
	
	    /**
     *  商户订单号
     */
    @Column(name = "orderno")
	@ApiModelProperty(value = "商户订单号")
    private String orderno;
	
	    /**
     *  第三方订单号：如微信，支付宝，银行卡等
     */
    @Column(name = "cono")
	@ApiModelProperty(value = "第三方订单号：如微信，支付宝，银行卡等")
    private String cono;
	
	    /**
     *  提现金额
     */
    @Column(name = "amount")
	@ApiModelProperty(value = "提现金额")
    private Long amount;
	
	    /**
     *  订单状态：0-未提现,待审核，1-已审核
     */
    @Column(name = "stauts")
	@ApiModelProperty(value = "订单状态：0-未提现,待审核，1-已审核")
    private Integer stauts;
	
	    /**
     *  提现日期
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "提现日期", hidden = true )
    private Long crtTime;
	
	    /**
     *  审核日期
     */
    @Column(name = "finish_time")
	@ApiModelProperty(value = "审核日期")
    private Long finishTime;
	
	    /**
     *  操作者ID
     */
    @Column(name = "oper_user")
	@ApiModelProperty(value = "操作者ID")
    private String operUser;
	

}
