package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 我的钱包
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
@Data
@Table(name = "my_wallet")
public class MyWallet implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
     *  id
     */
    @Column(name = "id")
	@ApiModelProperty(value = "id")
    private Long id;
	
	    /**
    *  用户ID
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("用户ID")
    private Integer userId;
	
	    /**
     *  余额(分)
     */
    @Column(name = "balance")
	@ApiModelProperty(value = "余额(分)")
    private Long balance;
	
	    /**
     *  已提现金额
     */
    @Column(name = "withdrawals")
	@ApiModelProperty(value = "已提现金额")
    private Long withdrawals;
	
	    /**
     *  进账总额(分)
     */
    @Column(name = "total_amount")
	@ApiModelProperty(value = "进账总额(分)")
    private Long totalAmount;

	/**
	 *  进账总额(分)
	 */
	@Column(name = "today_amount")
	@ApiModelProperty(value = "进账总额(分)")
	private Long todayAmount;
	
	    /**
     *  未入账金额
     */
    @Column(name = "unbooked")
	@ApiModelProperty(value = "未入账金额")
    private Long unbooked;
	
	    /**
     *  是否冻结：0-正常，1-冻结
     */
    @Column(name = "is_frozen")
	@ApiModelProperty(value = "是否冻结：0-正常，1-冻结")
    private Integer isFrozen;
	
	    /**
     *  最后进账时间
     */
    @Column(name = "last_intime")
	@ApiModelProperty(value = "最后进账时间")
    private Long lastIntime;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  版本
     */
    @Column(name = "version")
	@ApiModelProperty(value = "版本")
    private Integer version;
	

}
