package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 拥金明细表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
@Data
@Table(name = "app_user_selling_water")
public class AppUserSellingWater implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  身份职位
     */
    @Column(name = "position_id")
	@ApiModelProperty(value = "身份职位")
    private Integer positionId;
	
	    /**
     *  来源用户id
     */
    @Column(name = "source_id")
	@ApiModelProperty(value = "来源用户id")
    private Integer sourceId;
	
	    /**
     *  订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "订单id")
    private Integer orderId;

	/**
	 *  订单号
	 */
	@Column(name = "order_no")
	@ApiModelProperty(value = "订单号")
	private String orderNo;
	
	    /**
     *  商品id
     */
    @Column(name = "good_id")
	@ApiModelProperty(value = "商品id")
    private Integer goodId;
	
	    /**
     *  商品数量
     */
    @Column(name = "good_number")
	@ApiModelProperty(value = "商品数量")
    private Integer goodNumber;
	
	    /**
     *  类型 1=>一级上线提成
     */
    @Column(name = "type")
	@ApiModelProperty(value = "类型 1=>一级上线提成")
    private Integer type;
	
	    /**
     *  类别：0-正；1-负
     */
    @Column(name = "status")
	@ApiModelProperty(value = "类别：0-正；1-负")
    private Integer status;
	
	    /**
     *  商品标题
     */
    @Column(name = "title")
	@ApiModelProperty(value = "商品标题")
    private String title;
	
	    /**
     *  图片
     */
    @Column(name = "img")
	@ApiModelProperty(value = "图片")
    private String img;
	
	    /**
     *  售价
     */
    @Column(name = "price")
	@ApiModelProperty(value = "售价")
    private BigDecimal price;
	
	    /**
     *  提成百分比
     */
    @Column(name = "extract")
	@ApiModelProperty(value = "提成百分比")
    private Integer extract;
	
	    /**
     *  是否入账：0-未入账；1-已入账
     */
    @Column(name = "waiting")
	@ApiModelProperty(value = "是否入账：0-未入账；1-已入账")
    private Integer waiting;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Integer crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Integer updTime;

	/**
	 * 所获佣金
	 */
	@Column(name = "commission")
	private BigDecimal commission;
	

}
