package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.xxfc.platform.vehicle.biz.VehicleLicenseBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.common.VehicleBaseController;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.VehicleUserLicense;
import com.xxfc.platform.vehicle.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.vo.VehicleUserLicenseVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/user")
@Slf4j
@IgnoreClientToken

public class VehicleLicenseController extends VehicleBaseController<VehicleLicenseBiz> {


    @RequestMapping(value = "/license/update", method = RequestMethod.POST)
    public RestResponse update(@RequestBody VehicleUserLicenseVo licenseVo) throws Exception {
        AppUserDTO userDTO =getUserInfo();
        if(userDTO==null){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        licenseVo.setUserid(userDTO.getUserid());
        return baseBiz.update(licenseVo);
    }

    @RequestMapping(value = "/license/all", method = RequestMethod.POST)
    public RestResponse<PageDataVO<VehicleUserLicense>> all(
            @RequestParam(value="page",defaultValue="1")Integer  page,
            @RequestParam(value="limit",defaultValue="10")Integer  limit) throws Exception {
        AppUserDTO userDTO =getUserInfo();
          if(userDTO==null){
              return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
          }
        return RestResponse.suc(baseBiz.getAllByUserid( page,limit,userDTO.getUserid()));
    }
    @RequestMapping(value = "/license/one", method = RequestMethod.GET)
    public RestResponse one(
            @RequestParam(value="id",defaultValue="0")Integer  id) throws Exception {
        AppUserDTO userDTO =getUserInfo();
        if(userDTO==null||id==0){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return RestResponse.suc(baseBiz.getOneById(id));
    }

    @RequestMapping(value = "/license/del", method = RequestMethod.GET)
    public RestResponse del(
            @RequestParam(value="id",defaultValue="0")Integer  id) throws Exception {
        if(id==0){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return baseBiz.del(id);
    }





}
