package com.xxfc.platform.order.vo;

import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

@Data
public class AddRentVehicleDTO{
    //开始时间
    @Column(name = "start_time")
    @ApiModelProperty(value = "开始时间")
    private Long startTime;

    //结束时间
    @Column(name = "end_time")
    @ApiModelProperty(value = "结束时间")
    private Long endTime;

    //天数
    @Column(name = "day_num")
    @ApiModelProperty(value = "天数")
    private Integer dayNum;

    //取车地点
    @Column(name = "start_addr")
    @ApiModelProperty(value = "取车地点")
    private String startAddr;

    //还车地点
    @Column(name = "end_addr")
    @ApiModelProperty(value = "还车地点")
    private String endAddr;

    //费用详情
    @Column(name = "cost_detail")
    @ApiModelProperty(value = "费用详情")
    private String costDetail;

    //取车城市编号
    @Column(name = "start_city")
    @ApiModelProperty(value = "取车城市编号")
    private Integer startCity;

    //还车城市编号
    @Column(name = "end_city")
    @ApiModelProperty(value = "还车城市编号")
    private Integer endCity;

    //取车城市名称
    @Column(name = "start_city_name")
    @ApiModelProperty(value = "取车城市名称")
    private String startCityName;

    //还车城市名称
    @Column(name = "end_city_name")
    @ApiModelProperty(value = "还车城市名称")
    private String endCityName;

    //司机类型 1--公司司机；2--自己司机
    @Column(name = "driver_type")
    @ApiModelProperty(value = "司机类型 1--公司司机；2--自己司机")
    private Integer driverType;

    //自己司机ids
    @Column(name = "my_driver_ids")
    @ApiModelProperty(value = "自己司机ids")
    private String myDriverIds;

    //出发公司Id
    @Column(name = "start_company_id")
    @ApiModelProperty(value = "出发公司Id")
    private Integer startCompanyId;

    //结束公司Id
    @Column(name = "end_company_id")
    @ApiModelProperty(value = "结束公司Id")
    private Integer endCompanyId;

    //车型id
    @Column(name = "model_id")
    @ApiModelProperty(value = "车型id")
    private Integer modelId;
}
