package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppUserDetailBiz;
import com.github.wxiaoqi.security.admin.biz.MenuBiz;
import com.github.wxiaoqi.security.admin.biz.UserBiz;
import com.github.wxiaoqi.security.admin.entity.AppUserDetail;
import com.github.wxiaoqi.security.admin.entity.Group;
import com.github.wxiaoqi.security.admin.entity.Menu;
import com.github.wxiaoqi.security.admin.entity.User;
import com.github.wxiaoqi.security.admin.rpc.service.PermissionService;
import com.github.wxiaoqi.security.admin.vo.FrontUser;
import com.github.wxiaoqi.security.admin.vo.MenuTree;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.common.msg.BaseResponse;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 11:51
 */
@RestController
@RequestMapping("public")
public class PublicController {

    @Autowired
    private UserBiz userBiz;
    @Autowired
    private AppUserDetailBiz detailBiz;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @RequestMapping(value = "/userinfo-by-token", method = RequestMethod.GET)
    public @ResponseBody
    ObjectRestResponse userinfoByToken(String token) throws Exception {
        String username = userAuthUtil.getInfoFromToken(token).getUniqueName();
        if (username == null) {
            throw new Exception();
        }
        User user = userBiz.getUserByUsername(username);
        if (user == null) {
            throw new Exception();
        }
        return new ObjectRestResponse<User>().rel(true).data(user);
    }

    @RequestMapping(value = "/app/userinfo-by-token", method = RequestMethod.GET)
    public @ResponseBody
    ObjectRestResponse userDetailByToken(String token) throws Exception {
        String username = userAuthUtil.getInfoFromToken(token).getId();
        if (username == null) {
            throw new Exception();
        }
        Integer userid=Integer.parseInt(username);
        AppUserDetail user = detailBiz.getUserByUserid(userid);
        if (user == null) {
            throw new Exception();
        }
        return new ObjectRestResponse<AppUserDetail>().rel(true).data(user);
    }
}
