package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.vehicle.biz.AreaBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.Area;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 片区
 */
@RestController
@RequestMapping("/area")
@Slf4j
@IgnoreClientToken
public class AreaController extends BaseController<AreaBiz, Area> {
    /**
     * 获取所有片区
     * @return
     */
    @GetMapping("/findAll")
    public RestResponse<List<Area>> findAll(){
        return baseBiz.findAll();

    }

    @GetMapping("/areas")
    public List<Area> findAllAreas(){
        return baseBiz.findAllAreas();
    }

}
