package com.xxfc.platform.vehicle.mapper;



import com.xxfc.platform.vehicle.entity.VehicleExtension;
import com.xxfc.platform.vehicle.pojo.dto.VehicleExtensionFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleExtensionVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.additional.idlist.SelectByIdListMapper;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

public interface VehicleEextensionMapper extends Mapper<VehicleExtension>, SelectByIdListMapper<VehicleExtension,Integer> {


    void  delByIds(@Param("ids") List<Integer> ids,@Param("vehicleId")String vehicleId);

    List<VehicleExtensionVO>  selectList(@Param("vehicleId")String vehicleId,@Param("parentCataId")Integer parentCataId);

    List<VehicleExtensionVO>  selectListByApply(@Param("cataIds")List<Integer> cataIds,@Param("parentCataId")Integer parentCataId);


    List<VehicleExtensionVO>  selectListByParent(@Param("vehicleId")String vehicleId);

    List<VehicleExtensionVO>  selectListByApplyParent(@Param("cataIds")List<Integer> cataIds);


    List<VehicleExtensionVO>  selectListByPlatCata(VehicleExtensionFindDTO vehicleExtensionFindDTO);

    @Select("SELECT GROUP_CONCAT(cata_id) FROM vehicle_extension WHERE vehicle_id=#{vehicleId} and is_del = 0")
    String  getExtensionIds(@Param("vehicleId") String vehicleId);

}