package com.xxfc.platform.vehicle.config;

import com.github.wxiaoqi.security.common.config.rabbit.BindDTO;
import com.github.wxiaoqi.security.common.config.rabbit.RabbitCommonConfig;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;

import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.*;

/**
 * rabbitmq配置类
 * 包含： 不知道什么orderWater队列
 *
 * @author zhoujw
 * @date 2019/7/15
 */
@Configuration
public class RabbitVehicleConfig extends RabbitCommonConfig {



    //同步企业信息
    public static final String VEHICLE_CORPORATION_UPD_QUEUE = "vehicle.corporation:upd.queue";

    //同步门店信息
    public static final String VEHICLE_COMPANY_UPD_QUEUE = "vehicle.company:upd.queue";

    //接单退款消息
    public static final String VEHICLE_RECEVIE_REFUND_QUEUE = "vehicle.recevie:refund.queue";


    static {
        myQueue = new ArrayList<BindDTO>() {{
            //企业
            add(new BindDTO(VEHICLE_CORPORATION_UPD_QUEUE, ADMIN_TOPIC, KEY_CORPORATION_UPD));
            //门店
            add(new BindDTO(VEHICLE_COMPANY_UPD_QUEUE, ADMIN_TOPIC, KEY_COMPANY_UPD));
            //接单退款消息
            add(new BindDTO(VEHICLE_RECEVIE_REFUND_QUEUE, VEHICLE_TOPIC, KEY_VEHICLE_RECEIVE));
        }};
    }
}

