package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 需求接单表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
@Table(name = "vehicle_publish_receive")
public class VehiclePublishReceive implements Serializable {
	private static final long serialVersionUID = 1L;
	

    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;


	@Column(name = "code")
	@ApiModelProperty(value = "商品编号")
	private String code;


	@Column(name = "vehicle_id")
	@ApiModelProperty(value = "商品id")
	private String vehicleId;



	@Column(name = "name")
	@ApiModelProperty(value = "商品名称")
	private String name;



	@Column(name = "goods_type")
	@ApiModelProperty(value = "商品类型 1--房车；2--机车；3--游艇；4-豪车")
	private Integer goodsType;


	@Column(name = "brand_id")
	@ApiModelProperty(value = "品牌id")
	private Integer brandId;


	@Column(name = "category_id")
	@ApiModelProperty(value = "型号id")
	private Integer categoryId;

	@Column(name = "cover")
	@ApiModelProperty(value = "封面")
	private String cover;

	@Column(name = "extension_list")
	@ApiModelProperty(value = "扩展信息（逗号隔开）")
	private String extensionList;


	@Column(name = "publish_goods_id")
	@ApiModelProperty(value = "需求子id")
	private Integer publishGoodsId;


	@Column(name = "receive_user_id")
	@ApiModelProperty(value = "接单人id")
	private Integer receiveUserId;


	@Column(name = "receive_company_id")
	@ApiModelProperty(value = "接单公司id")
	private Integer receiveCompanyId;


	@Column(name = "receive_time")
	@ApiModelProperty(value = "接单时间")
	private Long receiveTime;


	@Column(name = "receive_order_no")
	@ApiModelProperty(value = "接单者订单号")
	private String receiveOrderNo;



	@Column(name = "publish_company_id")
	@ApiModelProperty(value = "发布公司id")
	private Integer publishCompanyId;



	@Column(name = "publish_order_no")
	@ApiModelProperty(value = "接单者订单号")
	private String publishOrderNo;


	@Column(name = "ack_time")
	@ApiModelProperty(value = "确认时间")
	private Long ackTime;



    @Column(name = "status")
	@ApiModelProperty(value = "状态：0-已接单待支付；1-已支付，待确认；2-拒绝；3-同意；4-取消")
    private Integer status;




    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;


    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;


	@Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
	private Integer isDel;
	

}
