package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.*;

@Data
@Table(name = "vehicle_manage_apply")
public class VehicleManageApply {

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;



    @Column(name = "vehicle_id")
    @ApiModelProperty("商品id")
    private String vehicleId;



    @Column(name = "type")
    @ApiModelProperty("申请类型：1-申请经营；2-取消经营；3-还车")
    private Integer type;


    @Column(name = "apply_id")
    @ApiModelProperty("申请公司id")
    private Integer applyId;



    @Column(name = "to_apply_id")
    @ApiModelProperty("被申请公司id")
    private Integer toApplyId;


    @Column(name = "verify_id")
    @ApiModelProperty("审核公司id")
    private Integer verifyId;



    @Column(name = "status")
    @ApiModelProperty("状态：0-未审核；1-审核通过;2-审核失败")
    private Integer status;



    @ApiModelProperty("失败原因")
    private String reason;


    @Column(name = "crt_time")
    private Long crtTime;


    @Column(name = "upd_time")
    private Long updTime;



    @Column(name = "is_del")
    @ApiModelProperty("是否删除：0-正常；1-删除")
    private Integer isDel;









}