package com.xxfc.platform.vehicle.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-09-19 17:48:20
 */
@Data
@Table(name = "vehicle_brand")
public class VehicleBrand implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  品牌编码
     */
    @Column(name = "code")
	@ApiModelProperty(value = "品牌编码")
    private String code;
	
	    /**
     *  品牌中文名称
     */
    @Column(name = "cn_name")
	@ApiModelProperty(value = "品牌中文名称")
    private String cnName;
	
	    /**
     *  品牌英文名称
     */
    @Column(name = "en_name")
	@ApiModelProperty(value = "品牌英文名称")
    private String enName;
	
	    /**
     *  品牌logo
     */
    @Column(name = "logo")
	@ApiModelProperty(value = "品牌logo")
    private String logo;
	
	    /**
     *  品牌专区大图
     */
    @Column(name = "banner")
	@ApiModelProperty(value = "品牌专区大图")
    private String banner;
	
	    /**
     *  品牌故事
     */
    @Column(name = "story")
	@ApiModelProperty(value = "品牌故事")
    private String story;
	
	    /**
     *  
     */
    @Column(name = "sort")
	@ApiModelProperty(value = "")
    private Integer sort;
	
	    /**
     *  品牌状态：1启用 2不启用
     */
    @Column(name = "status")
	@ApiModelProperty(value = "品牌状态：1启用 2不启用")
    private Integer status;
	
	    /**
     *  品牌推荐 1推荐 2不推荐
     */
    @Column(name = "recommend")
	@ApiModelProperty(value = "品牌推荐 1推荐 2不推荐")
    private Integer recommend;
	
	    /**
     *  审核状态：1：未审核 2：审核通过 3审核拒绝
     */
    @Column(name = "audit")
	@ApiModelProperty(value = "审核状态：1：未审核 2：审核通过 3审核拒绝")
    private Integer audit;
	
	    /**
     *  品牌删除状态 1：正常 2：删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "品牌删除状态 0：正常 1：删除")
    private Integer isDel;
	
	    /**
     *  品牌审核备注
     */
    @Column(name = "audit_remark")
	@ApiModelProperty(value = "品牌审核备注")
    private String auditRemark;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  修改时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "修改时间", hidden = true )
    private Date updTime;
	
	    /**
     *  版本号
     */
    @Column(name = "version")
	@ApiModelProperty(value = "版本号")
    private String version;


	/**
	 *  商品类型 1--房车；2--机车；3--游艇
	 */
	@Column(name = "goods_type")
	@ApiModelProperty(value = "商品类型 1--房车；2--机车；3--游艇")
	private Integer goodsType;

}
