package com.xxfc.platform.universal.inter;

import com.xxfc.platform.universal.constant.DictionaryKey;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.feign.ThirdFeign;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

import static com.xxfc.platform.universal.constant.DictionaryKey.APP_ORDER;


public interface CalculateInterface {
    public ThirdFeign getThirdFeign();
    /**
     * 计算包含多少天
     * @param startLong
     * @param endLong
     * @return
     */

    default Integer getIncludeDays(Long startLong, Long endLong) {
        Map<String, Dictionary> dictionaryMap = getThirdFeign().dictionaryGetAll4Map().getData();
        Long hourLong = (60L * 60L * 1000L);
        Long dayLong = hourLong * 24;
        Long bufferLong = Long.valueOf(dictionaryMap.get(APP_ORDER+ "_"+ DictionaryKey.RENT_TIME_BUFFER).getDetail()) * hourLong;

        //计算：使用天数 当前时间 - 开始时间的0时0分0秒
        Long bookTimeLag = endLong - startLong;

        //默认 已使用了一天
        if(bookTimeLag <= 0) {
            return 1;
        }

//        log.info("bookTimeLag {}", new BigDecimal(bookTimeLag + ""));
//        log.info("divide {}", new BigDecimal((24 * 60 * 60 * 1000)+ ""));
        Integer bookDays = new BigDecimal(bookTimeLag + "").divide(new BigDecimal(dayLong+ ""), 0, RoundingMode.DOWN).intValue();
        Long excess = bookTimeLag%dayLong;
        if(excess > bufferLong) {
            bookDays += 1;
        }

        if(0 == bookDays) {
            bookDays = 1;
        }
        return bookDays;
    }

    /**
     * 计算包含多少小时
     * @param startLong
     * @param endLong
     * @return
     */
    default Integer getIncludeHours(Long startLong, Long endLong) {
        Map<String, Dictionary> dictionaryMap = getThirdFeign().dictionaryGetAll4Map().getData();
        Long hourLong = (60L * 60L * 1000L);
        Long minuteLong = (60L * 1000L);
        //Long dayLong = hourLong * 24;
        Long bufferLong = Long.valueOf(dictionaryMap.get(APP_ORDER+ "_"+ DictionaryKey.RENT_TIME_HOUR_BUFFER).getDetail()) * minuteLong;

        //计算：使用天数 当前时间 - 开始时间的0时0分0秒
        Long bookTimeLag = endLong - startLong;

        //默认 已使用了1小时
        if(bookTimeLag <= 0) {
            return 1;
        }

//        log.info("bookTimeLag {}", new BigDecimal(bookTimeLag + ""));
//        log.info("divide {}", new BigDecimal(hourLong+ ""));
        Integer hourNums = new BigDecimal(bookTimeLag + "").divide(new BigDecimal(hourLong+ ""), 0, RoundingMode.DOWN).intValue();
        Long excess = bookTimeLag%hourLong;
        if(excess > bufferLong) {
            hourNums += 1;
        }

        if(0 == hourNums) {
            hourNums = 1;
        }
        return hourNums;
    }

}
