package com.xxfc.platform.tour.config;

import com.github.wxiaoqi.security.common.config.rabbit.BindDTO;
import com.github.wxiaoqi.security.common.config.rabbit.RabbitCommonConfig;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;

import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.*;

/**
 * rabbitmq配置类
 * 包含： 不知道什么orderWater队列
 *
 * @author zhoujw
 * @date 2019/7/15
 */
@Configuration
public class RabbitTourConfig extends RabbitCommonConfig {



    //同步企业信息
    public static final String TOUR_CORPORATION_UPD_QUEUE = "tour.corporation:upd.queue";

    //同步门店信息
    public static final String TOUR_COMPANY_UPD_QUEUE = "tour.company:upd.queue";


    static {
        myQueue = new ArrayList<BindDTO>() {{
            //企业
            add(new BindDTO(TOUR_CORPORATION_UPD_QUEUE, ADMIN_TOPIC, KEY_CORPORATION_UPD));
            //门店
            add(new BindDTO(TOUR_COMPANY_UPD_QUEUE, ADMIN_TOPIC, KEY_COMPANY_UPD));
        }};
    }
}

