package com.xxfc.platform.order.service;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.xxfc.platform.activity.entity.ActivityProduct;
import com.xxfc.platform.activity.entity.ActivityProductSpecs;
import com.xxfc.platform.activity.entity.Coupon;
import com.xxfc.platform.activity.feign.ActivityFeign;
import com.xxfc.platform.order.biz.OrderActivityDetailBiz;
import com.xxfc.platform.order.contant.enumerate.ItemTypeEnum;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.OrderItem;
import com.xxfc.platform.order.pojo.order.ActivityOrderBO;
import com.xxfc.platform.order.pojo.price.OrderPriceVO;
import com.xxfc.platform.universal.constant.DictionaryKey;
import com.xxfc.platform.universal.feign.ThirdFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;
import static com.xxfc.platform.universal.constant.DictionaryKey.APP_ORDER;

@Service
@Slf4j
public class OrderActivityService extends AbstractOrderHandle<OrderActivityDetailBiz, ActivityOrderBO> implements UserRestInterface {
	@Autowired
	ThirdFeign thirdFeign;

	@Autowired
	ActivityFeign activityFeign;

	private static Long autoCancelTime;

	@PostConstruct
	public void init() {
		this.channel = Coupon.CHANNEL_MEMBER;
		this.orderTypeEnum = OrderTypeEnum.ACTIVITY;
	}

	@Override
	public void initDetail(ActivityOrderBO bo) {
		super.initDetail(bo);
		initDictionary();

	}

	public void initDictionary() {
		dictionaryMap = thirdFeign.dictionaryGetAll4Map().getData();
		this.autoCancelTime = Long.valueOf(dictionaryMap.get(APP_ORDER + "_" + DictionaryKey.ACT_MEMBER).getDetail());
	}

	@Override
	public void handleDetail(ActivityOrderBO bo) {
		//设置订单状态为3
		bo.getOrder().setStatus(OrderStatusEnum.ORDER_UNPAY.getCode());
			bo.getOrder().setName(bo.getProductName());
			bo.getOrder().setPicture(bo.getPicture());
		super.handleDetail(bo);

		ActivityProductSpecs activityProductSpecs = activityFeign.get(bo.getSpecsId()).getData();
		if (activityProductSpecs != null) {
			bo.getOrder().setGoodsAmount(activityProductSpecs.getGoodsPrice());
			//修改规格库存
			if (activityProductSpecs.getStock() > 0) {
				activityProductSpecs.setSales(bo.getNumber());
				activityFeign.update(activityProductSpecs);

				//修改商品库存
				ActivityProduct activityProduct = new ActivityProduct();
				activityProduct.setId(activityProductSpecs.getGoodsId());
				activityProduct.setSales(bo.getNumber());
				activityFeign.updateProduct(activityProduct);
			}

		}

		//发送定时取消订单(30分钟)
		rabbitProduct.sendDelayMessage(bo.getOrder(), autoCancelTime);
	}



	@Override
	public void handleCalculate(ActivityOrderBO bo) {
		OrderPriceVO tpv = calculatePrice(bo);
		BeanUtil.copyProperties(tpv, bo.getOrder());
		BeanUtil.copyProperties(tpv, bo);
	}

	@Override
	public OrderPriceVO calculatePrice(ActivityOrderBO detail) {
		BigDecimal orderAmount = BigDecimal.ZERO;
		BigDecimal goodsAmount = BigDecimal.ZERO;
		BigDecimal realAmount = BigDecimal.ZERO;
		BigDecimal couponAmount = BigDecimal.ZERO;
		ActivityProductSpecs activityProductSpecs = activityFeign.get(detail.getSpecsId()).getData();
		if (activityProductSpecs != null) {
			detail.getOrder().setGoodsAmount(activityProductSpecs.getGoodsPrice());
		}
		//设置Item
		OrderItem memberOrderItem = orderItemBiz.initOrderItem(detail.getOrder().getGoodsAmount(), detail.getNumber(), detail.getName(), detail.getProductId() + "", ItemTypeEnum.ACTIVITY);

		detail.setItems(new ArrayList<OrderItem>());
		detail.getItems().add(memberOrderItem);

		//商品价格
		goodsAmount = goodsAmount.add(memberOrderItem.getCalculateAmount(Boolean.TRUE));

		//vehicleAmount 优惠券处理
		if (null != detail.getTickerNo() && detail.getTickerNo().size() > 0) {
			couponAmount = activityFeign.use(detail.getOrder().getUserId(), detail.getTickerNo(), detail.getOrder().getNo(), channel, goodsAmount, ActivityFeign.TYPE_NO_USE);
			if (couponAmount.compareTo(BigDecimal.ZERO) > 0) {
				detail.getOrder().setCouponTickerNos(detail.getTickerNo().stream().collect(Collectors.joining(",")));
				detail.getOrder().setHasDiscount(SYS_TRUE);
				memberOrderItem.handleCouponAmount(couponAmount);
			}
		}

		//订单总价格
		orderAmount = orderAmount.add(goodsAmount);
		//真实价格
		realAmount = realAmount.add(orderAmount).subtract(couponAmount);

		//生成订单明细
		OrderPriceVO opv = new OrderPriceVO();
		opv.setOrderAmount(orderAmount);
		opv.setGoodsAmount(goodsAmount);
		opv.setRealAmount(realAmount);
		opv.setCouponAmount(couponAmount);

		return opv;
	}
}
