package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.order.biz.InsureUserBiz;
import com.xxfc.platform.order.entity.InsureUser;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("/chw/insureUser")
@Slf4j
public class InsureUserController extends BaseController<InsureUserBiz, InsureUser> implements UserRestInterface {

    @Autowired
    UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    /**
     * 添加和更新
     * @param insureUser
     * @return
     */

    @ApiOperation("插入和更新")
    @PostMapping(value = "/app/addAndUpdate")
    @Transactional
    public ObjectRestResponse<InsureUser> addAndUpdate(@RequestBody InsureUser insureUser){
        try {
            if (insureUser.getId()==null||insureUser.getId()==0) {
                AppUserDTO userInfo = getAppUser();
                if (userInfo==null||userInfo.getUserid()==null||userInfo.getUserid()==0) {
                    return  ObjectRestResponse.createDefaultFail();
                }
                Integer userid = userInfo.getUserid();
                InsureUser insureUser1=new  InsureUser();
                insureUser1.setUserid(userid);
                insureUser1.setIdCard(insureUser.getIdCard());
                insureUser1.setIsdel(0);
                insureUser1=baseBiz.selectOne(insureUser1);
                if(insureUser1!=null){
                    return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"保险人证件号一样");
                }
                insureUser.setUserid(userid);
                insureUser.setCrtTime(System.currentTimeMillis());
                insureUser.setIsdel(0);
                baseBiz.insertSelective(insureUser);
            }else {
                insureUser.setUpdTime(System.currentTimeMillis());
                baseBiz.updateSelectiveById(insureUser);
            }
            return new ObjectRestResponse<InsureUser>();
        } catch (Exception e) {
            log.error(e.getMessage(), e);;
            throw new BaseException(ResultCode.FAILED_CODE);
        }


    }

    /**
     * 删除
     * @param
     * @return
     */

    @ApiOperation("删除")
    @PostMapping(value = "/app/del")
    @Transactional(rollbackFor = Exception.class)
    public ObjectRestResponse<InsureUser> del(@RequestBody InsureUser insureUser){
        try {
            baseBiz.updateSelectiveById(new InsureUser() {{
                setId(insureUser.getId());
                setIsdel(SYS_TRUE);
            }});
            return ObjectRestResponse.succ();
        } catch (Exception e) {
            log.error(e.getMessage(), e);;
            throw new BaseException(ResultCode.FAILED_CODE);
        }
    }

    @ApiOperation("通过id查询")
    @GetMapping(value = "/app/findById/{id}")
    public ObjectRestResponse<InsureUser> findById(@PathVariable Integer id){

        AppUserDTO userInfo = getAppUser();
        if (userInfo==null||userInfo.getUserid()==null||userInfo.getUserid()==0) {
            ObjectRestResponse.createDefaultFail();
        }
        Integer userid = userInfo.getUserid();
        InsureUser user = new InsureUser();
        user.setUserid(userid);
        user.setId(id);
        if (id==null||id==0) {
            ObjectRestResponse.createDefaultFail();
        }
        return ObjectRestResponse.succ(baseBiz.selectList(user));
    }


    /**
     * 获取全部出游人信息
     * @return
     */
    @GetMapping("/app/getInsureUserAll")
    public ObjectRestResponse getInsureUser(){
        AppUserDTO userInfo = getAppUser();
        if (userInfo==null||userInfo.getUserid()==null||userInfo.getUserid()==0) {
            ObjectRestResponse.createDefaultFail();
        }
        Integer id = userInfo.getUserid();
        List<InsureUser> insureUsers= baseBiz.selectByWeekend(w -> {
            w.andEqualTo(InsureUser::getIsdel, SYS_FALSE);
            w.andEqualTo(InsureUser::getUserid, id);
            return w;
        }, " crt_time desc ");
        return ObjectRestResponse.succ(insureUsers);
    }
}