package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.pojo.personinsurance.BgPageDTO;
import com.xxfc.platform.order.pojo.personinsurance.BgPageVO;
import org.springframework.stereotype.Service;

import com.xxfc.platform.order.entity.OrderPersonInsurance;
import com.xxfc.platform.order.mapper.OrderPersonInsuranceMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.List;

/**
 * 订单人身保险
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-26 18:56:21
 */
@Service
public class OrderPersonInsuranceBiz extends BaseBiz<OrderPersonInsuranceMapper, OrderPersonInsurance> {

    public PageDataVO<BgPageVO> selectOrderInfo(BgPageDTO dto) {
        PageDataVO<BgPageVO> pageList = PageDataVO.pageInfo(dto.initQuery(), ()-> mapper.selectOrderInfo(dto));

        pageList.getData().forEach(vo -> {
            vo.setInsuranceList(selectList(new OrderPersonInsurance(){{
                setOrderNo(vo.getNo());
            }}));
        });

        return pageList;
    }

    public List<OrderPersonInsurance> selectInsuranceInfo(BgPageDTO dto) {
        return mapper.selectInsuranceInfo(dto);
    }
}