package com.xxfc.platform.order.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 订单需求接单详情表
 * 
 * @author hezhen
 * @email 18178966185@163.com
 * @date 2019-09-09 15:51:16
 */
@Data
@Table(name = "order_pulish_receive_detail")
public class OrderPulishReceiveDetail implements Serializable {
	private static final long serialVersionUID = 1L;


    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	

    @Column(name = "order_id")
	@ApiModelProperty(value = "订单id")
    private Integer orderId;
	

    @Column(name = "company_id")
	@ApiModelProperty(value = "公司id")
    private Integer companyId;


	@Column(name = "publish_id")
	@ApiModelProperty(value = "需求id")
	private Integer publishId;
	


    @Column(name = "type")
	@ApiModelProperty(value = "类型：1-接单者；2-发布者")
    private Integer type;
	


    @Column(name = "receive_ids")
	@ApiModelProperty(value = "接单ids(逗号隔开)")
    private String receiveIds;



    @Column(name = "refuse_receive_ids")
    @ApiModelProperty(value = "拒绝的接单ids")
    private String refuseReceiveIds;
	

}
