package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 订单人身保险
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-26 18:56:21
 */
@Data
@Table(name = "order_person_insurance")
public class OrderPersonInsurance implements Serializable {
	private static final long serialVersionUID = 1L;

	public static final int STATUS_PAY = 1;
	public static final int STATUS_CNL = 2;
	public static final int STATUS_TOPAY = 3;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  基础订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "基础订单id")
    private Integer orderId;

	public void setOrderId(Integer orderId) {
		this.orderId = orderId;
	}

	/**
	 *  基础订单编号
	 */
	@Column(name = "order_no")
	@ApiModelProperty(value = "基础订单编号")
	private String orderNo;

	    /**
     *  姓名
     */
    @Column(name = "name")
	@ApiModelProperty(value = "姓名")
    private String name;
	
	    /**
     *  身份证号码
     */
    @Column(name = "id_card")
	@ApiModelProperty(value = "身份证号码")
    private String idCard;

	/**
	 *  投保人姓名
	 */
	@Column(name = "buy_insure_name")
	@ApiModelProperty(value = "投保人姓名")
	private String buyInsureName;

	/**
	 *  投保人身份证号码
	 */
	@Column(name = "buy_insure_id_card")
	@ApiModelProperty(value = "投保人身份证号码")
	private String buyInsureIdCard;

	/**
	 *  投保人手机号码
	 */
	@Column(name = "buy_insure_phone")
	@ApiModelProperty(value = "投保人手机号码")
	private String buyInsurePhone;

	/**
	 *  开始时间
	 */
	@Column(name = "start_time")
	@ApiModelProperty(value = "开始时间")
	private Long startTime;

	/**
	 *  结束时间
	 */
	@Column(name = "end_time")
	@ApiModelProperty(value = "结束时间")
	private Long endTime;

	/**
	 *  支付时间
	 */
	@Column(name = "pay_time")
	@ApiModelProperty(value = "支付时间")
	private Long payTime;

	/**
	 *  退款时间
	 */
	@Column(name = "refund_time")
	@ApiModelProperty(value = "退款时间")
	private Long refundTime;
	
	    /**
     *  订单的天数
     */
    @Column(name = "order_day")
	@ApiModelProperty(value = "订单的天数")
    private Integer orderDay;
	
	    /**
     *  保险的天数
     */
    @Column(name = "insurance_day")
	@ApiModelProperty(value = "保险的天数")
    private Integer insuranceDay;
	
	    /**
     *  金额
     */
    @Column(name = "amount")
	@ApiModelProperty(value = "金额")
    private BigDecimal amount;
	
	    /**
     *  状态 1--已支付；2--已退款; 3--待支付;
     */
    @Column(name = "status")
	@ApiModelProperty(value = "状态 1--已支付；2--已退款; 3--待支付;")
    private Integer status;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  创建者id
     */
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建者id")
    private String crtUser;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Date updTime;
	
	    /**
     *  更新者id
     */
    @Column(name = "upd_user")
	@ApiModelProperty(value = "更新者id")
    private String updUser;
	

}
