package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 保险人信息表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-30 17:44:50
 */
@Data
@Table(name = "insure_user")
public class InsureUser implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  用户id
     */
    @Column(name = "userid")
	@ApiModelProperty(value = "用户id")
    private Integer userid;
	
	    /**
     *  姓名
     */
    @Column(name = "name")
	@ApiModelProperty(value = "姓名")
    private String name;
	
	    /**
     *  身份证
     */
    @Column(name = "id_card")
	@ApiModelProperty(value = "身份证")
    private String idCard;

	//手机号
	@Column(name = "phone")
	@ApiModelProperty(value = "手机号")
	private String phone;

	/**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  是否删除：0-正常；1-删除
     */
    @Column(name = "isdel")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isdel;
	

}
