package com.github.wxiaoqi.security.admin.rest.admin;


import com.github.wxiaoqi.security.admin.biz.UserCommentBiz;
import com.github.wxiaoqi.security.admin.dto.UserCommentFindDTO;
import com.github.wxiaoqi.security.admin.entity.UserComment;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("backstage/comment")
@Api(tags = {"评论"})
public class AdminUserCommentController extends BaseController<UserCommentBiz,UserComment> implements UserRestInterface {



    @Autowired
    UserFeign userFeign;


    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }



    @GetMapping("selectList")
    @ApiModelProperty("列表")
    @IgnoreUserToken
    public  ObjectRestResponse selectList(UserCommentFindDTO commentFindDTO) {
        commentFindDTO.setIsDesc(1);
        return ObjectRestResponse.succ( baseBiz.selectListV2(commentFindDTO));
    }


    @PostMapping("del")
    @ApiModelProperty("评论删除")
    public  ObjectRestResponse del(@RequestBody UserComment userComment) {
        baseBiz.updateSelectiveById(userComment);
        return ObjectRestResponse.succ(); 
    }



}
