package com.github.wxiaoqi.security.admin.rest;


import com.github.wxiaoqi.security.admin.biz.CompanyWalletBiz;
import com.github.wxiaoqi.security.admin.dto.CompanyWalletDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/companyWallet")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"店铺钱包"})
public class AppCompanyWalletController extends BaseController<CompanyWalletBiz> {




    @GetMapping("info")
    @ApiModelProperty("店铺营收信息")
    public  ObjectRestResponse info(CompanyWalletDTO companyWalletDTO) {
        if (companyWalletDTO.getCompanyId() == null || companyWalletDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                companyWalletDTO.setCompanyId(companyIds.get(0));
            }
        }
        return ObjectRestResponse.succ(baseBiz.info(companyWalletDTO));
    }




}
