package com.github.wxiaoqi.security.admin.biz;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.dto.AppraiseLabeInfoDTO;
import com.github.wxiaoqi.security.admin.dto.CompanyApplyFindDTO;
import com.github.wxiaoqi.security.admin.entity.CompanyInfo;
import com.github.wxiaoqi.security.admin.vo.CompanyApplyVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import com.github.wxiaoqi.security.admin.entity.AppraiseLabelInfo;
import com.github.wxiaoqi.security.admin.mapper.AppraiseLabelInfoMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 评价标签
 *
 * @author wuweizhi
 * @email 18178966185@163.com
 * @date 2020-11-16 14:07:35
 */
@Service
@Slf4j
@Transactional
public class AppraiseLabelInfoBiz extends BaseBiz<AppraiseLabelInfoMapper, AppraiseLabelInfo> {

    public List<AppraiseLabelInfo> getList(AppraiseLabeInfoDTO appraiseLabeInfoDTO){
        return  mapper.selectList(appraiseLabeInfoDTO);
    }

    public ObjectRestResponse selectList(AppraiseLabeInfoDTO appraiseLabeInfoDTO){
        PageHelper.startPage(appraiseLabeInfoDTO.getPage(), appraiseLabeInfoDTO.getLimit());
        PageInfo<AppraiseLabelInfo> pageInfo = new PageInfo<>(getList(appraiseLabeInfoDTO));
        return ObjectRestResponse.succ(PageDataVO.pageInfo(pageInfo));
    }

    public ObjectRestResponse selectAppList(AppraiseLabeInfoDTO appraiseLabeInfoDTO){
        return ObjectRestResponse.succ(getList(appraiseLabeInfoDTO));
    }

    public void saveOrUpd(AppraiseLabelInfo appraiseLabelInfo){
        Long id = appraiseLabelInfo.getId() == null ? 0L :appraiseLabelInfo.getId();
        if (id  > 0L ){
            updateSelectiveById(appraiseLabelInfo);
        }else {
            insertSelective(appraiseLabelInfo);
        }
    }

}