package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 用户职位表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-09 10:00:42
 */
@Data
@Table(name = "app_user_job_level")
public class AppUserJobLevel implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  角色名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "角色名称")
    private String name;
	
	    /**
     *  等级
     */
    @Column(name = "level")
	@ApiModelProperty(value = "等级")
    private Integer level;
	

    /**
     *  状态：0-正常；1-禁用
     */
    @Column(name = "status")
	@ApiModelProperty(value = "状态：0-正常；1-禁用")
    private Integer status;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;
	

}
