package com.xxfc.platform.vehicle.mapper;

import com.alibaba.fastjson.JSONObject;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.pojo.dto.BranchCompanyListDTO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.additional.idlist.SelectByIdListMapper;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;
import java.util.Map;

public interface BranchCompanyMapper extends Mapper<BranchCompany>, SelectByIdListMapper<BranchCompany,Integer> {
    List<BranchCompany> search(@Param("lon") String lon, @Param("lat") String lat, @Param("addrCity") Integer addrCity);
    List<BranchCompany> selectByZoneId(Map<String, Object> param);

    List<Integer> findCompanyIdsByAreaId(@Param("areaId") Integer areaId);

    List<BranchCompanyListDTO > findBranchCompanys(@Param("provinceCode") Integer provinceCode,@Param("cityCode") Integer cityCode,@Param("name") String name);


    @Select("SELECT `code`,count(id) cd FROM `vehicle` WHERE is_del=0 and number_plate LIKE '%测试%' GROUP  BY code HAVING cd>=2")
    List<JSONObject> getList();
}