package com.xxfc.platform.vehicle.rest;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.msg.TableResultResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.google.common.collect.Maps;
import com.xxfc.platform.vehicle.biz.*;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.CustomIllegalParamException;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.constant.VehicleBookRecordStatus;
import com.xxfc.platform.vehicle.entity.*;
import com.xxfc.platform.vehicle.jobhandler.VehicleJobHandler;
import com.xxfc.platform.vehicle.pojo.*;
import com.xxfc.platform.vehicle.pojo.dto.VehicleFindAppDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleFindDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePlanDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("/chw/app/vehicle")
@Slf4j
@IgnoreClientToken
@Api(value="超惠玩车辆controller",tags={"超惠玩车辆接口"})
public class ChwAppVehicleController extends BaseController<VehicleBiz> implements UserRestInterface {

    @Autowired
    UserFeign userFeign;

    @Autowired
    VehicleBrandBiz vehicleBrandBiz;

    @Autowired
    VehicleCategoryBiz vehicleCategoryBiz;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    @ApiOperation("vehicleBrand查询所有")
    @RequestMapping(value = "/vehicleBrand/alls",method = RequestMethod.GET)
    @ResponseBody
    @IgnoreUserToken
    public ObjectRestResponse<List<VehicleBrand>> all(VehicleBrand vehicleBrand) {
        vehicleBrand.setIsDel(SYS_FALSE);
        return ObjectRestResponse.succ(vehicleBrandBiz.selectList(vehicleBrand));
    }

    @ApiOperation("vehicleCategory查询分页")
    @RequestMapping(value = "/vehicleCategory/page",method = RequestMethod.GET)
    @ResponseBody
    @IgnoreUserToken
    public TableResultResponse<VehicleCategory> list(@RequestParam Map<String, Object> params){
        //查询列表数据
        Query query = new Query(params);
        return vehicleCategoryBiz.selectPageByQuery(query);
    }

    @ApiOperation("vehicleCategory查询所有")
    @RequestMapping(value = "/vehicleCategory/alls",method = RequestMethod.GET)
    @ResponseBody
    @IgnoreUserToken
    public ObjectRestResponse<List<VehicleCategory>> vehicleCategoryAll(VehicleCategory vehicleCategory) {
        vehicleCategory.setIsDel(SYS_FALSE);
        return ObjectRestResponse.succ(vehicleCategoryBiz.selectList(vehicleCategory));
    }

}
