package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.BeanUtils;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.biz.VehicleApplyBiz;
import com.xxfc.platform.vehicle.biz.VehiclePublishBiz;
import com.xxfc.platform.vehicle.biz.VehiclePublishGoodsBiz;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleApply;
import com.xxfc.platform.vehicle.entity.VehiclePublish;
import com.xxfc.platform.vehicle.pojo.dto.VehicleApplyFindDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePublishFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehiclePublishVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/publish")
@Api(tags = {"商品需求"})
public class AppVehiclePublishController extends BaseController<VehiclePublishBiz> {

    @Autowired
    VehiclePublishGoodsBiz publishGoodsBiz;





    @PostMapping("save")
    @ApiModelProperty("发布需求")
    public  ObjectRestResponse apply(@RequestBody VehiclePublish vehiclePublish) {
     if (vehiclePublish.getCompanyId() == null || vehiclePublish.getCompanyId() == 0){
         List<Integer> companyIds = getBusinessUserCompanyIds();
         if (companyIds != null && companyIds.size() > 0){
             vehiclePublish.setCompanyId(companyIds.get(0));
         }
     }
     baseBiz.addOrUpd(vehiclePublish);
     return ObjectRestResponse.succ();
    }



    @GetMapping("app/unauth/selectList")
    @ApiModelProperty("需求列表")
    @IgnoreUserToken
    public  ObjectRestResponse selectList(VehiclePublishFindDTO publishFindDTO) {
        publishFindDTO.setSelectType(1);
        return  ObjectRestResponse.succ(baseBiz.selectList(publishFindDTO));
    }


    @GetMapping("selectListByCompany")
    @ApiModelProperty("我的发布")
    public  ObjectRestResponse selectListByCompany(VehiclePublishFindDTO publishFindDTO) {
        if (publishFindDTO.getCompanyId() == null || publishFindDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                publishFindDTO.setCompanyId(companyIds.get(0));
            }
        }
        publishFindDTO.setSelectType(2);
        return  ObjectRestResponse.succ(baseBiz.selectList(publishFindDTO));
    }


    @GetMapping("app/unauth/detail")
    @ApiModelProperty("详情")
    @IgnoreUserToken
    public  ObjectRestResponse detail(VehiclePublishFindDTO publishFindDTO) {
        PageDataVO<VehiclePublishVo> pageDataVO = baseBiz.selectList(publishFindDTO);
        List<VehiclePublishVo> list = pageDataVO.getData();
        VehiclePublishVo  publishVo = new VehiclePublishVo();
        if (CollectionUtils.isNotEmpty(list)){
            publishVo=list.get(0);
        }
        return ObjectRestResponse.succ(publishVo);
    }


    @GetMapping("orderDetail")
    @ApiModelProperty("订单详情")
    public  ObjectRestResponse orderDetail(VehiclePublishFindDTO publishFindDTO) {
        return ObjectRestResponse.succ(publishGoodsBiz.getListByOrderNo(publishFindDTO));
    }













}
