package com.xxfc.platform.vehicle.biz;



import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.vehicle.entity.VehiclePublishGoods;
import com.xxfc.platform.vehicle.mapper.VehiclePublishGoodsMapper;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePublishFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleExtensionVO;
import com.xxfc.platform.vehicle.pojo.vo.VehiclePublishGoodsVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;


@Service
@Slf4j
public class VehiclePublishGoodsBiz extends BaseBiz<VehiclePublishGoodsMapper, VehiclePublishGoods> {


    @Autowired
    VehicleExtensionBiz extensionBiz;




    public List<VehiclePublishGoodsVo> getList(VehiclePublishFindDTO publishFindDTO){
        List<VehiclePublishGoodsVo> list = mapper.selectList(publishFindDTO);
        setGoodsList(list);
        return list;
    }



    public List<VehiclePublishGoodsVo> getListByOrderNo(VehiclePublishFindDTO publishFindDTO){
        List<VehiclePublishGoodsVo> list = mapper.selectListByOrderNo(publishFindDTO);
        setGoodsList(list);
        return list;
    }

    public  void  setGoodsList(List<VehiclePublishGoodsVo> list){
        if (CollectionUtils.isNotEmpty(list)){
            for (VehiclePublishGoodsVo publishGoodsVo : list){
                String vehicleId = publishGoodsVo.getVehicleId();
                List<VehicleExtensionVO> extensionVOS = new ArrayList<>();
                if (StringUtils.isNotBlank(vehicleId)){
                    extensionVOS=extensionBiz.getTree(vehicleId);
                }else {
                    String extensionList = publishGoodsVo.getExtensionList();
                    if (StringUtils.isNotBlank(extensionList)){
                        extensionVOS=extensionBiz.getTreeByApply(Arrays.asList(extensionList.split(",")).parallelStream().map(s -> Integer.valueOf(s)).collect(Collectors.toList()));
                    }
                }
                publishGoodsVo.setExtensionVOS(extensionVOS);
            }
        }
    }









}
