package com.xxfc.platform.vehicle.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleCommonPriceInfo;
import com.xxfc.platform.vehicle.mapper.VehicleCommonPriceInfoMapper;
import com.xxfc.platform.vehicle.pojo.dto.VehicleCommonPriceDto;
import com.xxfc.platform.vehicle.pojo.vo.VehicleCommonPriceVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;

/**
 * 租车通用价格表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-05-11 09:16:23
 */
@Service
public class VehicleCommonPriceInfoBiz extends BaseBiz<VehicleCommonPriceInfoMapper, VehicleCommonPriceInfo> implements UserRestInterface {
	@Autowired
	UserFeign userFeign;

	@Autowired
	VehicleBiz vehicleBiz;

	@Override
	public UserFeign getUserFeign() {
		return userFeign;
	}

	public ObjectRestResponse<VehicleCommonPriceInfo> addOrUpdate(VehicleCommonPriceInfo vehicleCommonPriceInfo) {
		if (vehicleCommonPriceInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		Vehicle vehicle = vehicleBiz.get(vehicleCommonPriceInfo.getVehicleId());
		if (vehicle == null) {
			return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "车辆不存在！");
		}
		vehicleCommonPriceInfo.setModelId(vehicle.getModelId());
		setPowerData(vehicleCommonPriceInfo, false);
		vehicleCommonPriceInfo.setCompanyId(vehicle.getSubordinateBranch());
		List<Vehicle> vehicleList = null;
		if (vehicleCommonPriceInfo.getAllVehicleUse() != null && vehicleCommonPriceInfo.getAllVehicleUse() == 1) {//所有车辆可用
			vehicleList = vehicleBiz.getAllVehicleByCompanyId(vehicleCommonPriceInfo.getDataCompanyIds(), null);
		}
		if (vehicleCommonPriceInfo.getAllModelUse() != null && vehicleCommonPriceInfo.getAllModelUse() == 1) {//同车型可用
			vehicleList = vehicleBiz.getAllVehicleByCompanyId(vehicleCommonPriceInfo.getDataCompanyIds(), vehicle.getModelId());
		}
		if (vehicleList == null || vehicleList.size() <= 0) { //单个车辆可用
			VehicleCommonPriceInfo oldValue = getByVehicleId(vehicleCommonPriceInfo.getVehicleId());
			if (oldValue == null) {
				vehicleCommonPriceInfo.setId(null);
				insertSelectiveRe(vehicleCommonPriceInfo);
			} else {
				BeanUtil.copyProperties(vehicleCommonPriceInfo, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
				updateSelectiveByIdRe(oldValue);
			}
		}  else {
			vehicleList.parallelStream().forEach(vehicleInfo -> {
				if (vehicleInfo != null) {
					VehicleCommonPriceInfo oldValue = getByVehicleId(vehicleInfo.getId());
					if (oldValue == null) {
						oldValue = new VehicleCommonPriceInfo();
						BeanUtil.copyProperties(vehicleCommonPriceInfo, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
						oldValue.setVehicleId(vehicleInfo.getId());
						oldValue.setCompanyId(vehicleInfo.getSubordinateBranch());
						oldValue.setModelId(vehicleInfo.getModelId());
						oldValue.setId(null);
						insertSelectiveRe(oldValue);
					} else {
						BeanUtil.copyProperties(vehicleCommonPriceInfo, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
						oldValue.setVehicleId(vehicleInfo.getId());
						oldValue.setCompanyId(vehicleInfo.getSubordinateBranch());
						oldValue.setModelId(vehicleInfo.getModelId());
						mapper.updateByPrimaryKeySelective(oldValue);
					}
				}

			});
		}
		return ObjectRestResponse.succ();

	}


	public VehicleCommonPriceInfo getByVehicleId(String vehicleId) {
		Example example = new Example(VehicleCommonPriceInfo.class);
		example.createCriteria().andEqualTo("vehicleId", vehicleId).andEqualTo("isDel", 0);
		return mapper.selectOneByExample(example);
	}

	/**
	 * 获取所有车辆价格信息
	 * @param vehicleIds 逗号分隔
	 * @return
	 */
	public ObjectRestResponse<List<VehicleCommonPriceInfo>> getAllByVehicleIds(String vehicleIds) {
		if (StringUtils.isBlank(vehicleIds)) {
			return ObjectRestResponse.paramIsEmpty();
		}
		String[] vehicleId = vehicleIds.split(",");
		List<VehicleCommonPriceInfo> list = new ArrayList<>();
		if (vehicleId.length > 0) {
			for (String id : vehicleId) {
				if (StringUtils.isNotBlank(id)) {
					list.add(getByVehicleId(id));
				}
			}
		}
		return ObjectRestResponse.succ(list);
	}

	public ObjectRestResponse<PageDataVO<VehicleCommonPriceVo>> selectList(VehicleCommonPriceDto vehicleCommonPriceDto) {
		if (vehicleCommonPriceDto.getPage() == null) {
			vehicleCommonPriceDto.setPage(1);
		}
		if (vehicleCommonPriceDto.getLimit() == null) {
			vehicleCommonPriceDto.setLimit(10);
		}
		Query query = new Query(vehicleCommonPriceDto);
		PageDataVO<VehicleCommonPriceVo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectList(query.getSuper()));
		return ObjectRestResponse.succ(pageDataVO);
	}

}