package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 商品使用时间
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
@Table(name = "vehicle_use_time")
public class VehicleUseTime implements Serializable {
	private static final long serialVersionUID = 1L;
	

    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;



	@Column(name = "vehicle_id")
	@ApiModelProperty(value = "商品id")
	private String vehicleId;


	@Column(name = "company_id")
	@ApiModelProperty(value = "店铺id")
	private Integer companyId;



	@Column(name = "publish_id")
	@ApiModelProperty(value = "需求id")
	private Integer publishId;



	@Column(name = "start_time")
	@ApiModelProperty(value = "开始时间")
	private Long startTime;


	@Column(name = "end_time")
	@ApiModelProperty(value = "结束时间")
	private Long endTime;


	@Column(name = "status")
	@ApiModelProperty(value = "状态：1-开启；2-关闭")
	private Integer status;

	

    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;


    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	

}
