package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 需求商品子表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
@Table(name = "vehicle_publish_goods")
public class VehiclePublishGoods implements Serializable {
	private static final long serialVersionUID = 1L;
	

    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;


	@Column(name = "publish_id")
	@ApiModelProperty(value = "需求id")
	private Integer publishId;


    @Column(name = "vehicle_id")
	@ApiModelProperty(value = "商品id")
    private String vehicleId;


    @Column(name = "number")
	@ApiModelProperty(value = "商品数量")
    private Integer number;


	@Column(name = "receive_amount")
	@ApiModelProperty(value = "接单者服务费（单个商品）")
	private BigDecimal receiveAmount;



	@Column(name = "publish_amount")
	@ApiModelProperty(value = "发布服务费（单个商品）")
	private BigDecimal publishAmount;



	@Column(name = "goods_type")
	@ApiModelProperty(value = "商品类型 1--房车；2--机车；3--游艇；4-豪车")
	private Integer goodsType;


	@Column(name = "brand_id")
	@ApiModelProperty(value = "品牌id")
	private Integer brandId;


	@Column(name = "category_id")
	@ApiModelProperty(value = "型号id")
	private Integer categoryId;

	@Column(name = "cover")
	@ApiModelProperty(value = "封面")
	private String cover;

	@Column(name = "extension_list")
	@ApiModelProperty(value = "扩展信息（逗号隔开）")
	private String extensionList;


	@Column(name = "status")
	@ApiModelProperty(value = "状态：0-发布中；1-已取消；2-待收车,3-已完成")
	private Integer status;



    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;


    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;


	@Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
	private Integer isDel;
	

}
