package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.uccn.biz.SEOBiz;
import com.xxfc.platform.uccn.entity.SEO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("seo")
@Api(tags={"seo后台管理类"})
public class SEOController extends BaseController<SEOBiz, SEO> {



    @GetMapping("/app/unauth/officialWebsite/{modelId}")
    @ApiOperation(value = "获取官网seo")
    @IgnoreUserToken
    public ObjectRestResponse getSeoByModelId(@PathVariable Integer modelId){
        return ObjectRestResponse.succ(baseBiz.getSeoByModelId(modelId));
    }
}