package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.entity.OrderActiveDetail;
import com.xxfc.platform.order.mapper.OrderActiveDetailMapper;
import com.xxfc.platform.order.pojo.dto.OrderActiveDto;
import com.xxfc.platform.order.pojo.vo.OrderActivityVo;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
@Api("活动订单详情")
public class OrderActivityDetailBiz extends BaseBiz<OrderActiveDetailMapper, OrderActiveDetail> implements UserRestInterface {
	@Autowired
	UserFeign userFeign;
	@Override
	public UserFeign getUserFeign() {
		return userFeign;
	}

	public ObjectRestResponse getAll(OrderActiveDto dto) {
		//判断token是否存在
		UserDTO userDTO = getAdminUserInfo();
		if (userDTO == null) {
			return ObjectRestResponse.succ(new PageDataVO<>());
		}
		if (StringUtils.isNotBlank(dto.getPhone())) {
			AppUserLogin appUserLogin = userFeign.one(dto.getPhone());
			if (appUserLogin != null) {
				dto.setUserId(appUserLogin.getId());
			}
		}
		Query query = new Query(dto);
		PageDataVO<OrderActivityVo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.getAllActivityOrder(query.getSuper()));
		if (pageDataVO != null && pageDataVO.getData() != null) {
			pageDataVO.getData().parallelStream().forEach(orderActivityVo -> {
				AppUserDTO appUserVo = userFeign.userDetailById(orderActivityVo.getUserId()).getData();
				if (appUserVo != null) {
					orderActivityVo.setMobile(appUserVo.getUsername());
					orderActivityVo.setRealName(appUserVo.getRealname());
				}
			});
		}
		return ObjectRestResponse.succ(pageDataVO);
	}

	public ObjectRestResponse orderDetail(String no, AppUserDTO appUserDTO) {
		if (StringUtils.isBlank(no)) {
			return ObjectRestResponse.paramIsEmpty();
		}
		Map<String, Object> param = new HashMap<>();
		param.put("no", no);
		param.put("userId", appUserDTO.getUserid());
		List<OrderActivityVo> list = mapper.getAllActivityOrder(param);
		if (list != null && list.size() > 0) {
			return ObjectRestResponse.succ(list.get(0));
		}
		return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "订单不存在");
	}

	public  OrderActiveDetail getOne(Integer orderId) {
		Example example = new Example(OrderActiveDetail.class);
		example.createCriteria().andEqualTo("orderId", orderId);
		return mapper.selectOneByExample(example);
	}

}
