package com.xxfc.platform.order.pojo.order;

import cn.hutool.core.date.DateUtil;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.xxfc.platform.activity.entity.Coupon;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderItem;
import com.xxfc.platform.order.entity.inter.OrderDetail;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.pojo.OrderAccompanyDTO;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.pojo.BookVehicleVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class RentVehicleBO extends OrderRentVehicleDetail implements OrderDetail {
    private BaseOrder order;
    private VehicleModel vehicleModel;
    private BookVehicleVO bookVehicleVO;
    private Vehicle vehicle;

    /**
     * 订单标记 1--普通订单；2--需求预定申请订单；3--特惠租车订单
     */
    private Integer orderSign = 1;

    public Integer getOrderSign() {
        return orderSign;
    }

    public void setOrderSign(Integer orderSign) {
        this.orderSign = orderSign;
    }

    /**
     * 是否使用出租免费天数
     */
    private Integer rentFreeDay;
    private AppUserDTO appUserDTO;

    /**
     * 促成人联系方式
     */
    @ApiModelProperty(value = "促成人联系方式")
    String facilitatePhone;

    /**
     * 下单来源，1--app；2--小程序
     */
    private Integer orderOrigin;

    /**
     * 优惠券*
     */
    private List<String> tickerNo;

    /**
     * 订单子项
     */
    List<OrderItem> items;

    @ApiModelProperty(value = "随车物品", hidden = true)
    private List<OrderAccompanyDTO> accompanyItems;

    /**
     * 创建用户 -1+后台用户id 后台系统
     */
    String crtUser;

    /**
     * 用途 1 租车
     */
    @ApiModelProperty(hidden = true)
    Integer useType = 1;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 开始时间字符串
     */
    private String startDateStr;

    /**
     * 结束时间字符串
     */
    private String endDateStr;

    /**
     * 开始时间字符串
     */
    private String startDateTimeStr;

    /**
     * 结束时间字符串
     */
    private String endDateTimeStr;

    public void initDate() {
        this.startDate = DateUtil.date(getStartTime());
        this.endDate = DateUtil.date(getEndTime());
        this.startDateStr = DateUtil.formatDate(this.startDate);
        this.endDateStr = DateUtil.formatDate(this.endDate);
        this.startDateTimeStr = DateUtil.formatDateTime(this.startDate);
        this.endDateTimeStr = DateUtil.formatDateTime(this.endDate);
    }
}
