package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 特惠租车
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-10-31 11:02:42
 */
@Data
@Table(name = "special_rent")
public class SpecialRent implements Serializable {
	private static final long serialVersionUID = 1L;

	public static final int STATUS_DEL = 0;
	public static final int STATUS_CRT = 1;
	public static final int STATUS_CNL = 2;
	public static final int STATUS_ORDER = 4;
	public static final int STATUS_AUTOCNL_ORDER = 502;
	public static final int STATUS_AUTOCNL_TOPAY = 503;
	public static final int STATUS_AUTOCNL_PAYED = 504;
	public static final int STATUS_ERR = 6;
	public static final int STATUS_SUCC = 7;


	public static final int ORDER_STATUS_TOPAY = 1;
	public static final int ORDER_STATUS_PAY = 2;
	public static final int ORDER_STATUS_CANCEL = 3;

	/**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  状态
0--删除
1--创建
2--取消
3--等待下单
4--下单成功

     */
    @Column(name = "status")
	@ApiModelProperty(value = "状态 0--删除 1--创建 2--取消 3--等待下单 4--下单成功")
    private Integer status;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  创建者id
     */
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建者id")
    private String crtUser;
	
	    /**
     *  用户id
     */
    @Column(name = "join_user_id")
	@ApiModelProperty(value = "用户id")
    private Integer joinUserId;
	
	    /**
     *  更新者id
     */
    @Column(name = "upd_user")
	@ApiModelProperty(value = "更新者id")
    private String updUser;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Date updTime;
	
	    /**
     *  开始公司id
     */
    @Column(name = "start_company_id")
	@ApiModelProperty(value = "开始公司id")
    private Integer startCompanyId;
	
	    /**
     *  结束公司id
     */
    @Column(name = "end_company_id")
	@ApiModelProperty(value = "结束公司id")
    private Integer endCompanyId;
	
	    /**
     *  车辆id
     */
    @Column(name = "vehicle_id")
	@ApiModelProperty(value = "车辆id")
    private String vehicleId;
	
	    /**
     *  开始时间
     */
    @Column(name = "start_time")
	@ApiModelProperty(value = "开始时间")
    private Long startTime;
	
	    /**
     *  结束时间
     */
    @Column(name = "end_time")
	@ApiModelProperty(value = "结束时间")
    private Long endTime;
	
	    /**
     *  订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "订单id")
    private Integer orderId;
	
	    /**
     *  订单编号
     */
    @Column(name = "order_no")
	@ApiModelProperty(value = "订单编号")
    private String orderNo;
	
	    /**
     *  开始公司名称
     */
    @Column(name = "start_company_name")
	@ApiModelProperty(value = "开始公司名称")
    private String startCompanyName;
	
	    /**
     *  结束公司名称
     */
    @Column(name = "end_company_name")
	@ApiModelProperty(value = "结束公司名称")
    private String endCompanyName;
	
	    /**
     *  开始城市编码
     */
    @Column(name = "start_city_code")
	@ApiModelProperty(value = "开始城市编码")
    private Integer startCityCode;
	
	    /**
     *  结束城市编码
     */
    @Column(name = "end_city_code")
	@ApiModelProperty(value = "结束城市编码")
    private Integer endCityCode;
	
	    /**
     *  发布的后台用户id
     */
    @Column(name = "publish_user_id")
	@ApiModelProperty(value = "发布的后台用户id")
    private Integer publishUserId;
	
	    /**
     *  发布的公司（门店）id
     */
    @Column(name = "publish_company_id")
	@ApiModelProperty(value = "发布的公司（门店）id")
    private Integer publishCompanyId;
	
	    /**
     *  预约记录id
     */
    @Column(name = "book_record_id")
	@ApiModelProperty(value = "预约记录id")
    private Long bookRecordId;
	
	    /**
     *  状态 1--待支付 2--已支付 3--已取消
     */
    @Column(name = "order_status")
	@ApiModelProperty(value = "状态 1--待支付 2--已支付 3--已取消")
    private Integer orderStatus;
	
	    /**
     *  品牌id
     */
    @Column(name = "brand_id")
	@ApiModelProperty(value = "品牌id")
    private Integer brandId;
	
	    /**
     *  型号id
     */
    @Column(name = "category_id")
	@ApiModelProperty(value = "型号id")
    private Integer categoryId;
	
	    /**
     *  商品类型 1--房车；2--机车；3--游艇
     */
    @Column(name = "goods_type")
	@ApiModelProperty(value = "商品类型 1--房车；2--机车；3--游艇")
    private Integer goodsType;

	/**
	 * 单价，每日价格
	 */
	@Column(name = "unit_price")
	@ApiModelProperty(value = "单价，每日价格")
	private BigDecimal unitPrice;

	/**
	 * 商品信息，json
	 */
	@Column(name = "goods_json")
	@ApiModelProperty(value = "商品信息json")
	private String goodsJson;

	public void setGoodsJson(String goodsJson) {
		this.goodsJson = goodsJson;
	}

	@Column(name = "brand_name")
	@ApiModelProperty("品牌名称")
	private String brandName;

	@Column(name = "category_name")
	@ApiModelProperty("型号名称")
	private String categoryName;

	@Column(name = "is_del")
	private Integer isDel;

	/**
	 *  取车城市名称
	 */
	@Column(name = "start_city_name")
	@ApiModelProperty(value = "取车城市名称")
	private String startCityName;

	/**
	 *  还车城市名称
	 */
	@Column(name = "end_city_name")
	@ApiModelProperty(value = "还车城市名称")
	private String endCityName;

	/**
	 *  超时时间戳
	 */
	@Column(name = "over_time")
	@ApiModelProperty(value = "超时时间戳", hidden = true )
	private Long overTime;

	/**
	 *  超时时间戳
	 */
	@Column(name = "price_type")
	@ApiModelProperty(value = "超时时间戳", hidden = true )
	private Integer priceType;
}
