package com.xxfc.platform.activity.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.biz.ActivityBiz;
import com.xxfc.platform.activity.dto.ActivityDTO;
import com.xxfc.platform.activity.dto.ActivityLuckDrawFindDTO;
import com.xxfc.platform.activity.entity.Activity;
import com.xxfc.platform.activity.vo.ActivityLuckyDrawListVo;
import com.xxfc.platform.activity.vo.ActivityVo;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("admin/activity")
public class ActivityAdminController extends BaseController<ActivityBiz, Activity> {

    /**
     * 活动列表
     *
     * @param activityDTO
     * @return
     */
    @PostMapping("/allList")
    @ResponseBody
    public ObjectRestResponse<PageDataVO<ActivityVo>> listActivtyLuckyDrawWithPage(@RequestBody ActivityDTO activityDTO) {
        return baseBiz.getAllByPage(activityDTO);
    }
}