package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.CompanyWalletCathBiz;
import com.github.wxiaoqi.security.admin.dto.CompanyAccountDTO;
import com.github.wxiaoqi.security.admin.dto.CompanyWalletPwdDTO;
import com.github.wxiaoqi.security.admin.vo.ApplyCathVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/companyWalletCath")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"店铺提现"})
public class AppCompanyCathController extends BaseController<CompanyWalletCathBiz> {


    @GetMapping("sendSMS")
    @ApiOperation("发送验证码")
    public ObjectRestResponse sendSMS() throws Exception{
        baseBiz.sendSMS(getUserName());
        return ObjectRestResponse.succ();
    }


    @GetMapping("checkCode")
    @ApiOperation("检查验证码")
    public ObjectRestResponse checkCode(
            @RequestParam(value = "mobilecode", defaultValue = "") String mobilecod) throws Exception{
        return baseBiz.checkCode(getUserName(), mobilecod);
    }



    @PostMapping("setPwd")
    @ApiOperation("设置密码")
    public ObjectRestResponse setPwd(@RequestBody CompanyWalletPwdDTO companyWalletPwdDTO) throws Exception{
        if (companyWalletPwdDTO.getCompanyId() == null || companyWalletPwdDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                companyWalletPwdDTO.setCompanyId(companyIds.get(0));
            }
        }
        if (StringUtils.isBlank(companyWalletPwdDTO.getPhone())){
            companyWalletPwdDTO.setPhone(getUserName());
        }
        return baseBiz.setPwd(companyWalletPwdDTO);
    }


    @GetMapping("checkSetPwdOrAccount")
    @ApiOperation("检查用户是否设置过(支付密码或银行卡)")
    public ObjectRestResponse checkSetPwdOrAccount(@RequestParam(value = "companyId", defaultValue = "0") Integer companyId) {
        if (companyId == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                companyId=companyIds.get(0);
            }
        }
        return ObjectRestResponse.succ(baseBiz.checkSetPwdOrAccount(companyId));
    }

    @PostMapping("applyCath")
    @ApiOperation("提现申请")
    public ObjectRestResponse applyCath(@RequestBody ApplyCathVo applyCathVo) {
        if (applyCathVo.getUserId() == null || applyCathVo.getUserId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                applyCathVo.setUserId(companyIds.get(0));
            }
        }
        return baseBiz.applyCath(applyCathVo);
    }


    @PostMapping("updAccount")
    @ApiOperation("设置银行卡")
    public ObjectRestResponse updAccount(@RequestBody CompanyAccountDTO companyAccountDTO) {
        if (companyAccountDTO.getCompanyId() == null || companyAccountDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                companyAccountDTO.setCompanyId(companyIds.get(0));
            }
        }
        baseBiz.updAccount(companyAccountDTO);
        return ObjectRestResponse.succ();
    }







}
