package com.github.wxiaoqi.security.admin.mapper;




import com.github.wxiaoqi.security.admin.dto.CompanyWalletDTO;
import com.github.wxiaoqi.security.admin.dto.WalletDetailDTO;
import com.github.wxiaoqi.security.admin.entity.CompanyWallet;
import com.github.wxiaoqi.security.admin.vo.CompanyWalletVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import tk.mybatis.mapper.common.Mapper;

import java.math.BigDecimal;
import java.util.List;

/**
 * 我的钱包
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
public interface CompanyWalletMapper extends Mapper<CompanyWallet>  {

    void  updMyWater(CompanyWallet companyWallet);


    @Update("UPDATE `company_wallet` SET `is_frozen`=#{state} WHERE `id`=#{id}" )
    void forbiddenWalletById(@Param("id") Integer id, @Param("state") Integer state);


    CompanyWallet sumAmount(WalletDetailDTO walletDetailDTO);


    List<CompanyWalletVo> selectList(CompanyWalletDTO walletDTO);


    @Select("SELECT IFNULL(SUM(amount),0)  FROM base_order_revenue WHERE amount > 0 and is_del = 0 and  company_id=#{companyId}  and from_unixtime(crt_time/1000,'%Y-%m-%d')=date_format(now(),'%Y-%m-%d')")
    BigDecimal todayAmount(@Param("companyId") Integer companyId);


    @Select("SELECT IFNULL(SUM(amount),0)  FROM company_wallet_detail WHERE type=1 and company_id=#{companyId}  and from_unixtime(crt_time/1000,'%Y-%m')=#{month}")
    BigDecimal monthAmount(@Param("companyId") Integer companyId,@Param("month") String month);


    @Select("SELECT IFNULL(SUM(amount),0)  FROM base_order_revenue WHERE amount > 0 and is_del = 0 and  company_id=#{companyId} and status = 0")
    BigDecimal notDoAmount(@Param("companyId") Integer companyId);
}
