package com.github.wxiaoqi.security.admin.entity;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/24 16:41
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "user_comment")
public class UserComment {
    @Id
    @GeneratedValue(generator = "JDBC")
    private Integer id;
    /**
     * 被评论id
     */
    @Column(name = "parent_id")
    private Integer parentId;
    /**
     * 资源ID
     */
    @Column(name = "soure_id")
    private String soureId;
    /**
     * 资源用户id/或店铺id
     */
    @Column(name = "soure_user_id")
    private Integer soureUserId;
    /**
     * 资源类型：1-活动；2-商品
     */
    @Column(name = "soure_type")
    private Integer soureType;
    /**
     * 用户ID
     */
    @Column(name = "user_id")
    private Integer userId;
    /**
     * 店铺id
     */
    @Column(name = "company_id")
    private Integer companyId;
    /**
     * 用户ID
     */
    @Column(name = "comment_text")
    private String commentText;
    /**
     * 评论图片
     */
    @Column(name = "images")
    private String images;
    /**
     * 回复评论者的ID
     */
    @Column(name = "to_user_id")
    private Integer toUserId;
    /**
     * 最上级id
     */
    @Column(name = "root_parent_id")
    private Integer rootParentId;
    /**
     * 回复数量
     */
    @Column(name = "reply_num")
    private Integer replyNum;
    /**
     *评论时间
     */
    @Column(name = "create_time")
    private Date createTime;
    /**
     * 是否可见：0-否；1是
     */
    @Column(name = "is_show")
    private Integer isShow;
    /**
     * 是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
    private Integer isDel;

    @Transient
    private  Integer  isCompany;

    /**
     * 订单编号
     */
    @Column(name = "order_no")
    private String orderNo;

    /**
     * 评论详情
     */
    @Column(name = "appraise_json")
    private String appraiseJson;

    /**
     * 评价总分
     */
    @Column(name = "point")
    private Integer point;

    /**
     * 是否匿名0-不匿名，1-匿名
     */
    @Column(name = "is_anonymous")
    private Integer isAnonymous;

    @Transient
    private List<JSONObject> jsonList;
}
